﻿<#
    CCC to BIN, a PowerShell Tool
    Copyright 2018 Joe Strosnider
    Version: 0.1

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#>

$Script:showWindowAsync = Add-Type -MemberDefinition @"
[DllImport("user32.dll")]
public static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);
"@ -Name "Win32ShowWindowAsync" -Namespace Win32Functions -PassThru
$null = $showWindowAsync::ShowWindowAsync((Get-Process -Id $pid).MainWindowHandle, 0)

Function Get-FileName($initialDirectory)
{   
 [System.Reflection.Assembly]::LoadWithPartialName("System.windows.forms") |
 Out-Null

 $OpenFileDialog = New-Object System.Windows.Forms.OpenFileDialog
 $OpenFileDialog.initialDirectory = $initialDirectory
 $OpenFileDialog.filter = "All files (*.*)| *.*"
 $OpenFileDialog.ShowDialog() | Out-Null
 $OpenFileDialog.filename
}

$path = Get-FileName -initialDirectory "C:\"

if ($path -eq "") {
Add-Type -AssemblyName PresentationFramework
[system.windows.messagebox]::Show('File not specified. Exiting.', 'CCC to BIN')
exit
}

# Get the size of the file, in bytes.
$FileSize = [string[]](Get-Childitem -LiteralPath $path | select length)    # Get the number of bytes as a string with crap on it
$FileSize = $FileSize.Replace("@{Length=","")                        # strip off...
$FileSize = $FileSize.Replace("}","")                                # ... the crap
$FileSize = [int]$FileSize                                           # convert the string to an int
$hexstring = [System.String]::Format('{0:X6}', $FileSize) + "4000"   # throw that out as full preamble string

# Convert the preamble string to an array of bytes.
$preamble = [byte[]]::new($hexstring.Length / 2)
For($i=0; $i -lt $hexstring.Length; $i+=2){$preamble[$i/2] = [convert]::ToByte($hexstring.Substring($i, 2), 16)}

# define the postamble array of bytes.
[Byte[]] $postamble = 0xff,0x00,0x00,0x40,0x00

# Grab the original file into a byte array.
$source = [io.file]::ReadAllBytes($path)

# Mash our stuff together.
$final = $preamble + $source + $postamble

# Construct the output filename
$outfile = (Get-Item -LiteralPath $path).Basename + ".bin"
$outpath = (Get-Item -LiteralPath $path ).DirectoryName + "\"+ $outfile

# Write out the converted file
[io.file]::WriteAllBytes($outpath, $final)

# Show the file in Explorer
$commandArgs = @('/select,',$outpath)
& explorer $commandArgs